"""
██████╗ ██╗  ██╗ █████╗ ███╗   ██╗████████╗ ██████╗ ███╗   ███╗
██╔══██╗██║  ██║██╔══██╗████╗  ██║╚══██╔══╝██╔═══██╗████╗ ████║
██████╔╝███████║███████║██╔██╗ ██║   ██║   ██║   ██║██╔████╔██║
██╔═══╝ ██╔══██║██╔══██║██║╚██╗██║   ██║   ██║   ██║██║╚██╔╝██║
██║     ██║  ██║██║  ██║██║ ╚████║   ██║   ╚██████╔╝██║ ╚═╝ ██║
╚═╝     ╚═╝  ╚═╝╚═╝  ╚═╝╚═╝  ╚═══╝   ╚═╝    ╚═════╝ ╚═╝     ╚═╝

Copyright (c) 2025 Rıza Emre ARAS <r.emrearas@proton.me>
Licensed under AGPL-3.0 - see LICENSE file for details

Dataclass model for wstunnel_bridge — ServerConfig.

Mutable (frozen=False) — db.py may update fields after SQL operations.
Default values match schema.sql column defaults.
"""

from __future__ import annotations

from dataclasses import dataclass


@dataclass
class ServerConfig:
    bind_url: str = ""
    restrict_to: str = ""
    restrict_path_prefix: str = ""
    tls_certificate: str = ""
    tls_private_key: str = ""
    state: str = "stopped"
    updated_at: int = 0
